# 第五章 中国开源商业现状

## 5.1 开源商业化呈现井喷之势，中国迎来开源创业的浪潮

开源作为一种高效的协作方式，让更多的开发者参与并产出更高质量的源代码。同时，“开源带货“逐渐盛行，通过开源的方式帮助产品及企业触及更多用户，由此带来了巨大的商业化或专业版本服务的机会。还有非常关键的一点是，开源是基础软件的最佳选择，相比很难让用户接受的闭源“黑箱”，开源基础软件众所周知的安全可靠性能够促使更多的用户来使用。

从2013年开始，开源商业化在国际市场取得了较大的突破，实现了10倍速的增长。开源产品的优越性得到了更好的验证，在商业上也落地生花。非常显著的一点是，收入过1亿美金的开源公司有了爆发性的增长，从过去只有屈指可数的几家如今已迅速增长至五十余家。比如，在2021年里，Confluent（Kafka背后的开源商业公司）、HashiCorp、GitLab成功上市，市值都在百亿美元规模，开源的商业模型已经得到了良好的验证。

在中国市场，随着数字化时代的到来，每个行业都因此发生巨变，过去不具备开发者技术力量的传统公司都在转型为技术公司。我们已经可以看到当今诸多市值很高的公司背后，都是技术在驱动，由此开源成为重中之重。开源已经成为了整个互联网产业的基石，几乎所有的互联网公司都在使用开源软件，它极大地降低了软件生产的成本，随着商业化的发展，也将让更多的企业享受到开源带来的好处。

数字经济的推动拉动了技术本身的发展，和商业模式闭环的形成，由此，中国迎来了开源创业的浪潮。据CSDN关于中国开源项目融资的数据统计显示，在2021年，开源融资较2020年实现了几乎翻倍的增长。同时我们也可以看到，从融资分布的技术领域来看，核心集中在数据库、云原生和人工智能上。

| 时间	| 组织（公司/基金会/个人）| 	核心开源项目| 	作者/创始人	| 融资轮次| 	融资金额	| 投资方| 	技术领域| 
| -| -| -| -| -| -| -| -| 
| 2022 年 2 月|	澜舟科技|	Mengzi	|周明|	Pre-A 轮|	近亿元人民币|	联想创投、斯道资本、创新工场|	人工智能|
| 2022 年 2 月|	太极图形|	Taichi	|胡渊鸣、匡冶|	A 轮	|5000 万|	源码资本、GGV 纪源资本、BAI 资本、红杉中国|	计算机视觉、编程语言|
| 2022 年 1 月|	SphereEx|	Apache ShardingSphere|	张亮、潘娟|	Pre-A轮|	近千万美元|	嘉御资本领投，红杉中国种子基金、初心资本、指数创投跟投，指数资本担任独家财务顾问|	数据库|
| 2021 年 11 月|	Jina AI	|Jina|	肖涵|	A 轮	|3000 万美元	|Canaan Partners、Mango Capital、GGV 纪源资本、SAP.iO Fund、云启资本	|人工智能|
| 2021 年 11 月|	星汉未来|	BridgX|	刘道儒|	Pre-A 轮	|未披露	|经纬创投	|云原生|
| 2021 年 11 月	|Alluxio, Inc.|	Alluxio	|李浩源|	C 轮|	5000 万美元|	高瓴创投、Andreessen Horowitz、七海资本、火山石资本、华泰创新	|
| 2021 年 10 月	|StreamNative|	Apache Pulsar|	郭斯杰|	A 轮	|2300万美元	|Prosperity7 Ventures、华泰创新、源码资本、红杉中国	|云原生、中间件|
| 2021 年 10 月	|矩阵起源（Matrix Origin）|	MatrixOne|	王龙	|战略融资|	数千万美元|	钟鼎资本、五源资本、险峰K2VC、基石资本	|
| 2021 年 9 月|	端点Terminus|	Erda|	赵沣伟|	B 轮|	6 亿人民币|	华平投资、红杉中国、阿里云、中金佳成	|云原生|
| 2021 年 8 月|	澜舟科技|	Mengzi|	周明|	天使轮|	未披露	|创新工场|	人工智能|
| 2021 年 8 月|	偶数科技	|Apache HAWQ	|常雷	|B+轮|	近 2 亿元人民币|	某科技巨头、红杉资本、红点中国	|大数据|
| 2021 年 8 月|	Datafuse Labs	|Databend	|张雁飞	|天使轮|	数百万美元|	高瓴资本、华创资本、九合创投|	
| 2021 年 8 月|	KodeRover|	Zadig|	李倩|	Pre-A轮	|数千万人民币|	经纬中国、盈动资本|	云原生|
| 2021 年 7 月|	云智慧	|OMP-运维管理平台	|殷晋	|E 轮	|1.5 亿美元|	红杉中国、波士顿投资、FutureX Capital天际资本、CPE源峰、ASG、SIG海纳亚洲创投基金、链兴资本、银盛泰资本、敦鸿资产	|运维|
| 2021 年 7 月|	平凯星辰（北京）PingCAP	|TiDB	|刘奇、黄东旭、崔秋|	E 轮|	估值 30 亿美元|	红杉中国、明势资本、新加坡政府投资公司（GIC）、五源资本、云启资本、GGV纪源资本、BAI资本|	数据库|
| 2021 年 7 月|	星汉未来	|BridgX	|刘道儒	|天使轮|	数百万美元|	明势资本、初心资本|	云原生|
| 2021 年 6 月|	深圳支流科技	|Apache APISIX	|温铭|	A+轮|	数百万美元|	经纬中国、顺为资本、真格基金|	云原生|
| 2021 年 6 月|	矩阵起源（Matrix Origin）|	MatrixOne	|王龙	|天使轮	|千万级美元	|五源资本、险峰K2VC、源来资本、微光创投	大数据|
| 2021 年 5 月|	涛思数据|	TDengine|	陶建辉|	B 轮|	4700 万美元|	经纬中国（领投）、GGV 纪源资本、红杉资本中国、指数资本	数据库、|物联网|
| 2021 年 5 月|	SphereEx|	Apache ShardingSphere|	张亮	|天使轮	|数百万美元|	红杉中国、初心资本|	数据库|
| 2021 年 5 月|	九章云极DataCanvas|	DingoDB	|方磊、尚明栋|	C 轮	|3 亿人民币	|赛富投资基金、尚珹投资、领沨资本、君紫资本、珂玺资本、易华录投资|	数据库|
| 2021 年 4 月|	太极图形|	Taichi|	胡渊鸣、匡冶|	天使轮	|未披露	|红杉中国种子基金	|计算机视觉、编程语言|
| 2021 年 4 月|	麒麟软件|	优麒麟|	谌志华|	B 轮	|未披露	|上海翎贲、君度投资、燕园创投、旭源资本	|操作系统|
| 2021 年 4 月|	Kyligence|	Apache Kylin|	韩卿|	D 轮|	7000 万美元	|浦银国际、中金资本、歌斐资产、国方资本、ASG、宏兆基金、浦耀信晔、红点中国、斯道资本、顺为资本	|大数据|
| 2021 年 3 月|	深圳支流科技	|Apache APISIX|	温铭、王院生|	A 轮	|数百万美元	|真格基金、顺为资本	|云原生|
| 2021 年 3 月|	鼎石科技	|StarRocks	|李海磊、叶谦、赵纯|	Pre-A 轮|	未披露	|Atypical Ventures	|数据库|
| 2021 年 3 月|	端点Terminus|	Erda|	赵沣伟|	A 轮	|超 4 亿元人民币|	红杉资本、阿里云、耀途资本|	云原生|
| 2021 年 3 月|	ZStack云轴科技|	ZStack|	张鑫	|战略融资|	未披露|	中国电信投资	|云计算|
| 2021 年 2 月|	一流科技	|OneFlow|	袁进辉|	A 轮|	5000 万人民币|	高瓴资本|	人工智能|
| 2021 年 2 月|	深圳支流科技|	Apache APISIX	|温铭、王院生|	Pre-A 轮|	百万级美元|	真成投资、真格基金|	云原生|
| 2021 年 2 月|	鼎石科技	|StarRocks	|李海磊、叶谦、赵纯|	天使轮|	数百万美元	|明势资本|	数据库|
| 2021 年 1 月|	北京易捷思达科技|	EasyStack|	陈喜伦|	E 轮|	未披露	|京东数科|	云计算|
| 2020 年 12 月|	深圳支流科技|	Apache APISIX|	温铭、王院生|	天使轮|	百万级美元	|真格基金、真成投资|	云原生|
| 2020 年 12 月	|EMQ（杭州映云科技有限公司）|	EMQ X Broker|	李枫	|B 轮	|1.5 亿人民币	|高瓴创投、GGV纪源资本、嘉御资本、东方富海|	云原生、物联网|
| 2020 年 11 月	|平凯星辰（北京）PingCAP	|TiDB	|刘奇、黄东旭、崔秋|	D 轮|	2.7 亿美元|	GGV纪源资本、Access Technology Ventures、晨曦投资、时代资本、五源资本、BAI资本、Coatue Management、FutureX Capital天际资本、昆仑资本、挚信资本、经纬创投、云启资本|	数据库|
| 2020 年 11 月	|欧若数网|	NebulaGraph|	叶小萌|	Pre-A+轮	|近千万美元|	源码资本、红点中国、经纬中国	|数据库|
| 2020 年 11 月|	Zilliz|	Milvus|	谢超|	B 轮	|4300 万美元|	高瓴创投、挚信资本、Pavilion Capital、五源资本、云启资本|	人工智能、数据库|
| 2020 年 11 月|	端点Terminus|	Erda|	赵沣伟	|Pre-A+ 轮	|未披露|	耀途资本|	云原生|
| 2020 年 9 月|	Jina AI	|Jina|	肖涵	|Pre-A轮|	600 万美元|	GGV 纪源资本、SAP、iO Fund、云启资本|	人工智能|
| 2020 年 8 月|	StreamNative	|Apache Pulsar|	郭斯杰|	Pre-A 轮|	数百万美元	源码资本、红杉中国|	云原生、中间件|
| 2020 年 8 月|	EMQ（杭州映云科技有限公司）|	EMQ X Broker|	李枫|	A+ 轮	|数千万人民币|	嘉御资本|	云原生、物联网|
| 2020 年 8 月|	ZStack云轴科技|	ZStack|	张鑫|	B+ 轮	|2.3 亿人民币	|三峡鑫泰、中网投、交银国际、安恒信息、朗玛峰创投、天堂硅谷、宁波闻勤、阿里云、深创投、小苗朗程、联新资本、前海母基金、朗程资本、常州政府投资基金|	云计算|
| 2020 年 6 月|	OceanBase奥星贝斯	|OceanBase|	阳振坤|	股权融资|	未披露	|蚂蚁集团	|数据库|
| 2020 年 6 月|	鼎石科技|	StarRocks|	李海磊、叶谦、赵纯	|种子轮|	未披露	|神策数据|	数据库|
| 2020 年 4 月|	涛思数据	|TDengine|	陶建辉|	A 轮|	超 1000 美元|	GGV纪源资本、红杉中国	|数据库、物联网|
| 2020 年 3 月|	EMQ（杭州映云科技有限公司）	|EMQ X Broker|	李枫	|A 轮	|未披露|	东方富海、九合创投、晨晖创投|	云原生、物联网|
| 2020 年 1 月|	上海睿赛德电子科技|	RT-Thread	|熊谱翔|	B 轮|	未披露|	GGV纪源资本、君联资本、华秋电子	|操作系统、物联网|
| 2020 年 1 月|	涛思数据|	TDengine|	陶建辉|	Pre-A 轮|	近千万美元	|GGV纪源资本、红杉中国种子基金、北纬科技	|数据库、物联网|
| 2019 年 5 月|	旷视科技|	MegEngine	|印奇、唐文斌|	D 轮|	7.5 亿美元|	工银资管有限公司、中银投资、麦格理资本、阿里巴巴|	人工智能|

*表1 中国开源项目融资列表 [来源](https://gitcode.net/open-source-lab/List-of-Chinese-Open-Source-Project-Financing)*

中国要在全球开源立住脚，一方面头部公司要发展，另一方面，应该利用工程师红利。中国拥有全球最大的开发者群体，让开发者大量地涌入开源世界做贡献，通过开源的协作，能够开发出更多有用的软件。其次，将软件与硬件进行结合也是一个巨大的优势。

## 5.2 开源商业模式：Open Core加云原生成主流

开源项目的商业模式有着不同的路径和阶段，总体来说，经历了三代的演进：

* 第一代，以红帽为代表，以支持和服务为主。现在依然存在这样的需求。
* 第二代，以MongoDB、Cloudera等为代表，有开源项目，做付费的商业版本。这个模式不太成功。
* 第三代，Open Core的模式，本身可能是基础软件的属性，又能够提供云服务，在商业上形成闭环。可以说，Open Core加上Cloud Native，是开源商业化大爆发最为重要的两个内在因素。此外，还有一个外部因素，就是在数字经济的驱动下，这个模式形成了飞轮效应。

而具体到开源模式上，可以总结归纳出以下10种主要的商业模式：

* **订阅式产品化和技术支持模式**：类似于红帽基于Linux社区版做了Linux企业版并以订阅式的方式长期向企业客户收费，除此之外，还基于开源项目提供打包、培训或者咨询服务类的技术支持。
* **Dual-License双授权模式**：指代码具有两套许可证。一套是传统的开源许可证（如GPL），另一套是商业许可证。
* **社区版开源，增值闭源的Open Core模式**：把一部分软件开源，另一部分增值的闭源收费。我们经常见到很多“社区版”的软件可能就是开源的，而与之对应的“企业版”的模式就很可能提供了很多额外功能并收费。比如Kafka、Cassandra、GitLab都是这种模式。
* **SaaS - 软件即服务上云模式**：商业变现的一开始就决定把软件运营到云上，用 SaaS 服务的方式对使用者提供“可租用的软件服务”，而不是把软件的所有权卖给用户，让用户自己去运维。SaaS 的好处很多，从营收模型上看，客户会每个月、每年源源不断的贡献收入，容易获得高估值。对客户的好处不言而喻，主要包括：避免前期一次性购买软件和专用硬件的高额成本；部署快、随时享受升级；运维责任转嫁到了 SaaS 提供商身上，有供应商提供管理服务。
* **广告收益型**：如Google PHP Live。
* **软、硬一体化**：如IBM、HP、SUN
* **附属品**：O’Relly IDG/Linuxworld
* **降低用户TCO（捆绑软件或服务）**：Oracle Andriod
* **政府资助科研型**：FreeBSD 部分Linux发行商
* **其他模式**：利用开源软件来搭建应用系统，通过开源更快更便捷地获取基于开源操作系统的生态合作伙伴，通过开源生态上的产品分成等模式。
 
## 5.3 开源商业公司的护城河：得生态者得天下

企业如果想要基于开源来构建核心技术，在公司的发展过程中，如何通过开源技术形成持续的竞争力，确保后来者难以快速抄袭或超越？首先最为关键的就是构建生态。好的生态是最强的竞争优势和护城河。比如基于Open Core的商业模式，解决在某一领域最擅长也是客户关心的痛点问题，并输出成为一个Quick Start。

所谓 Quick Start，即能够将开源软件解决某一特定场景问题的实操指南。当用户尝鲜一个开源软件时，一开始下载安装部署，如果突然卡住，按流程文档依然无法运行起来，会大概率流失这个用户。所以，Quick Start 至关重要，一定要让进入的门槛特别低，让用户能够立即用起来，当后续碰到问题也能够互相帮助解决，甚至于想出一些当前软件不具备的功能，并付诸开发，由此就会形成一个围绕该项目的开发者社区。

有了开发者社区后，忠实的用户会将他们使用的方法写成文档并传播，这样就有更多的用户进来了。这其实就是一个飞轮效应。最终，会有越来越多的软件包产生。当生态一旦形成后，因为你是项目的原作者，会加大用户对你所提供的服务的信任，这是更高效的开发方式。

当然，源代码只是很小的一部分，更重要的是通过用户的参与形成一个生态。当软件开放后，对市场的需求、用户的认知，会比不开放的更深入。开源的竞争是在一个相对的市场上，竞争更大，也更有长久的生命力。

因此，对于一个基于开源项目的商业公司而言，未来的竞争力不应该仅仅停留在代码层面，而是基于代码和面向特定用户服务的能力，构建起开发者和用户的生态，由此形成竞争壁垒。

需要注意的是，任何一个开源软件都有可能被分叉出去，这是一种常态。作为原作者，要对自己有信心，对项目的掌控程度、未来增加新功能的能力应该是最强的，当跑得越快、更多的功能做起来、软件用户越来越多，分叉并不会带来特别的影响。当然，开源赋予了用户永远选择的权利，无论是分支还是主干，核心都在于谁做得更好、保持领先。

## 5.4 开源项目商业化要有全球化视野

我们正处在开源产业发展最好的机遇期，能够看到非常多的开源初创项目和企业正在快速发展和成长。对于开源企业和创业者而言，如何保持快速的发展，首先要解决一个特定的问题、解决用户痛点，然后给用户创造价值，这是所有商业能够存在的根本。当然，也要反问自己，现在做的这个项目，和市面上现有的软件有何差别，具备哪些独特性，甚至是一个跨代的架构。如果这些存在的话，那么机会是很多的。

另外，做增量市场还是存量市场，有很多详细的策略，将这些充分分析后，能够让开源项目商业化走得更顺一些。

同时，做开源项目，一定要有全球化的视野。通过开源，全世界的用户都可以触达到，这是一个巨大的机会。
